// Autor: Tonko Sabolcec

#include <bits/stdc++.h>

#define FOR(i, a, b) for (int i = (int)(a); i < (int)(b); ++i)
#define REP(i, n) FOR(i, 0, n)
#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

#define x first
#define y second

using namespace std;

struct Triple {
  int x, y, z;
};

int q, n;
int cards[4][10];
int cnt_full[4];

bool bio[4][4];
int full[4];

Triple stk[40];
Triple ans[40];
int stk_pt;
int ans_pt;

int best;

enum PushTypes {
  FULL,
  CARD
};

inline void push(int type, int x, int y) {
  stk[stk_pt++] = {type, x, y};
  switch (type) {
    case CARD : cards[x][y]--; break;
    case FULL : full[x]++; break;
  }
}

inline void pop() {
  stk_pt--;
  auto t = stk[stk_pt];
  switch (t.x) {
    case CARD : cards[t.y][t.z]++; break;
    case FULL : full[t.y]--; break;
  }
}

void rec(int dep, int x) {
  {
    int score = 0;
    push(FULL, x, 0);
    for (int i = 0; i < 4; ++i) {
      if (full[i])
        score += cnt_full[i];
    }
    for (int i = 0; i < stk_pt; ++i) {
      if (stk[i].x != FULL && !full[stk[i].y])
        score++;
    }
    if (score > best) {
      best = score;
      ans_pt = stk_pt;
      for (int i = 0; i < stk_pt; ++i) {
        ans[i] = stk[i];
      }
    }
    pop();
  }
  
  if (dep == 5)
    return;
  
  for (int i = 0; i < 4; ++i) {
    if (i == x) continue;
    if (bio[x][i]) continue;
    for (int j = 0; j < 10; ++j) {
      if (!cards[x][j] || !cards[i][j]) continue;
      
      push(FULL, x, 0);
      push(CARD, x, j);
      push(CARD, i, j);
      bio[x][i] = 1;
      
      rec(dep+1, i);
      
      bio[x][i] = 0;
      pop();
      pop();
      pop();
    }
  }
}

void reconstruct() {
  for (int i = 0; i < ans_pt; ++i) {
    auto t = ans[i];
    if (t.x == CARD) cards[t.y][t.z]--;
  }
  for (int i = 0; i < ans_pt; ++i) {
    auto t = ans[i];
    if (t.x == CARD) {
      printf(" %c%d", t.y + 'A', t.z);
    } else {
      for (int j = 0; j < 10; ++j) {
        while (cards[t.y][j] > 0) {
          cards[t.y][j]--;
          printf(" %c%d", t.y + 'A', j);
        }
      }
    }
  }
  printf("\n");
}

pair<int, int> load_card() {
  static char s[3];
  scanf("%s", s);
  s[0] -= 'A';
  s[1] -= '0';
  return {s[0], s[1]};
}

void solve() {
  pair<int, int> c0 = load_card();
  scanf("%d", &n);
  REP(i, n) {
    pair<int, int> c = load_card();
    cards[c.x][c.y]++;
    cnt_full[c.x]++;
  }
  rec(0, c0.x);
  for (int i = 0; i < 4; ++i) {
    if (i == c0.x) continue;
    if (cards[i][c0.y]) {
      push(CARD, i, c0.y);
      rec(1, i);
      pop();
    }
  }
  printf("%d", best);
  reconstruct();
}

void clear() {
  memset(cards, 0, sizeof cards);
  memset(cnt_full, 0, sizeof cnt_full);
  stk_pt = 0;
  ans_pt = 0;
  best = 0;
}

int main(void) {
  scanf("%d", &q);
  while (q--) {
    clear();
    solve();
  }
  return 0;
}

